﻿/*
	VERSION: 1.0
	
	PURPOSE:
		This system allows you to easily play sound-effects
		without them interupting each other.
	
	BONUS FEATURES:
		Individual volume  (each sound has its own volume)
		Global volume  (scales every sound's volume, while retaining relative volume levels)
	
	USAGE:
		#include "makeSoundSystem.as"
		soundSystem = makeSoundSystem();	
		soundSystem.playSound(linkage, [volume]);
		soundSystem.stopAll();
		
	NOTE:
		This treats an array as an object as well,
		so there are variables stored outside the elements!
		(ie:  The array is also the container)
	NOTE:
		Because no movieClip container is used in this system,
		volume controls are NOT available.
*/
makeSoundSystem = function()
{
	// create sound container
	var _this = new Array();
	
	
	
	_this.playSound = function( soundName, volume )
	{
		var volume = (volume!=undefined) ? volume : 100;		// optional parameter
		
		// Create a new sound
		var new_sound = new Sound();
		_this.push( new_sound );
		
		// store this sound's volume
		new_sound.volume = volume;
		
		// apply volume
		new_sound.setVolume( new_sound.volume * (_this.volume/100) );		// this sound's volume * global volume
		
		// define the sound effect
		new_sound.attachSound( soundName );
		
		// play the sound
		new_sound.start();
		
		
		
		new_sound.remove = function()
		{
			// find this sound in the sound_array
			for (var i=0; i<_this.length; i++)
			{
				if( this == _this[i] )
				{
					// splice out this sound
					_this.splice( i, 1 );
					
					// stop searching
					break;
				}// if:  this sound is found in the array
			}// for:  sound_array
		}// remove()
		
		
		
		// remove the sound object when it's done playing
		new_sound.onSoundComplete = function()
		{
			new_sound.remove();
		}// onSoundComplete()
	}// playSound()
	
	
	
	_this.stopAll = function()
	{
		// empty the sound_array
		for( var nam in _this)
		{
			_this[nam].stop();
			_this.pop();
		}// for...in:  sound_array
	}// stopAll()
	
	
	
	return _this;
}// makeSoundSystem()
